// ---------------------------------------------------------------------------------------------------------------------------------
//  _______ __  __                 _     
// |__   __|  \/  |               | |    
//    | |  | \  / | __ _ _ __     | |__  
//    | |  | |\/| |/ _` | '_ \    | '_ \ 
//    | |  | |  | | (_| | |_) | _ | | | |
//    |_|  |_|  |_|\__,_| .__/ (_)|_| |_|
//                      | |              
//                      |_|              
//
// Generic texture mapper
//
// Best viewed with 8-character tabs and (at least) 132 columns
//
// ---------------------------------------------------------------------------------------------------------------------------------
//
// Restrictions & freedoms pertaining to usage and redistribution of this software:
//
//  * This software is 100% free
//  * If you use this software (in part or in whole) you must credit the author.
//  * This software may not be re-distributed (in part or in whole) in a modified
//    form without clear documentation on how to obtain a copy of the original work.
//  * You may not use this software to directly or indirectly cause harm to others.
//  * This software is provided as-is and without warrantee. Use at your own risk.
//
// For more information, visit HTTP://www.FluidStudios.com
//
// ---------------------------------------------------------------------------------------------------------------------------------
// Originally created on 12/06/2000 by Paul Nettle
//
// Copyright 2000, Fluid Studios, Inc., all rights reserved.
// ---------------------------------------------------------------------------------------------------------------------------------

#ifndef	_H_TMAP
#define	_H_TMAP

// ---------------------------------------------------------------------------------------------------------------------------------
// Constants
// ---------------------------------------------------------------------------------------------------------------------------------

extern	const	unsigned int	textureWidth;
extern	const	unsigned int	textureHeight;
extern	const	unsigned int	subShift;
extern	const	unsigned int	subSpan;

// ---------------------------------------------------------------------------------------------------------------------------------
// The vertex structure.  Note that this uses a linked list.  I tend to prefer
// them for ease of managing polygons with large numbers of dynamic vertices,
// though lists will work fine, too.
// ---------------------------------------------------------------------------------------------------------------------------------

typedef	struct	vertex
{
	float	u, v, w;
	float	x, y, z;
	int	iy;
	struct	vertex *next;
} sVERT;

// ---------------------------------------------------------------------------------------------------------------------------------
// The edge structure.  This is used to keep track of each left & right edge
// during scan conversion.  The algorithm does not pre-build an edge list
// prior to rendering, rather it renders edges as it builds them.  This
// structure is used only to keep the variables together.
// ---------------------------------------------------------------------------------------------------------------------------------

typedef	struct	edge
{
	float	u, du;
	float	v, dv;
	float	w, dw;
	float	x, dx;
	int	height;
} sEDGE;

// ---------------------------------------------------------------------------------------------------------------------------------
// Prototypes
// ---------------------------------------------------------------------------------------------------------------------------------

void	drawTexture();
void	drawAffineTexturedPolygon(sVERT *verts, unsigned int *frameBuffer, float *zBuffer, const unsigned int pitch);
void	drawPerspectiveTexturedPolygon(sVERT *verts, unsigned int *frameBuffer, float *zBuffer, const unsigned int pitch);
void	drawSubPerspectiveTexturedPolygon(sVERT *verts, unsigned int *frameBuffer, float *zBuffer, const unsigned int pitch);

#endif
// ---------------------------------------------------------------------------------------------------------------------------------
// TMap.h - End of file
// ---------------------------------------------------------------------------------------------------------------------------------
